% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsbinom.R
\name{Neutrosophic Binomial}
\alias{Neutrosophic Binomial}
\alias{dnsbinom}
\alias{pnsbinom}
\alias{qnsbinom}
\alias{rnsbinom}
\title{Neutrosophic Binomial Distribution}
\usage{
dnsbinom(x, size, prob)

pnsbinom(q, size, prob, lower.tail = TRUE)

qnsbinom(p, size, prob)

rnsbinom(n, size, prob)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{size}{number of trials (zero or more), which must be a positive interval.}

\item{prob}{probability of success on each trial, \eqn{0 \le prob \le 1}.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsbinom} gives the distribution function,
 \code{dnsbinom} gives the density,
 \code{qnsbinom} gives the quantile function and
 \code{rnsbinom} generates random variables from the Binomial Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the nuetrosophic binomial distribution with
parameters \code{size} = \eqn{n} and \code{prob} = \eqn{p_N}.
}
\details{
The neutrosophic binomial distribution with parameters \eqn{n} and \eqn{p_N}
has the density
\deqn{f_X(x)=\bigg(\begin{array}{c}n \\ x\end{array}\bigg) p_N^{x}\left(1-p_N\right)^{n-x}}
for \eqn{n \in \{1, 2, \ldots\}} and \eqn{p_N \in (p_L, p_U)} which must be \eqn{0<p_N<1}
and \eqn{x \in \{0, 1, 2, \ldots\}}.
}
\examples{
# Probability of X = 17 when X follows bin(n = 20, p = [0.9,0.8])
dnsbinom(x = 17, size = 20, prob = c(0.9, 0.8))
x <- matrix(c(15, 15, 17, 18, 19, 19), ncol = 2, byrow = TRUE)
dnsbinom(x = x, size = 20, prob = c(0.8, 0.9))

pnsbinom(q = 17, size = 20, prob = c(0.9, 0.8))
pnsbinom(q = c(17, 18), size = 20, prob = c(0.9, 0.8))
pnsbinom(q = x, size = 20, prob = c(0.9, 0.8))

qnsbinom(p = 0.5, size = 20, prob = c(0.8, 0.9))
qnsbinom(p = c(0.25, 0.5, 0.75), size = 20, prob = c(0.8, 0.9))


# Simulate 10 numbers
rnsbinom(n = 10, size = 20, prob = c(0.8, 0.9))

}
\references{
Granados, C. (2022). Some discrete neutrosophic distributions with
        neutrosophic parameters based on neutrosophic random variables.
        \emph{Hacettepe Journal of Mathematics and Statistics}, 51(5),
        1442-1457.
}
