% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntfy.R
\name{ntfy_done_with_timing}
\alias{ntfy_done_with_timing}
\title{Notify Completion of a Process with Timing}
\usage{
ntfy_done_with_timing(
  x,
  message = paste0("Process completed in ", time_result, "s"),
  title = "ntfy_done_with_timing()",
  tags = "stopwatch",
  topic = ntfy_topic(),
  server = ntfy_server(),
  auth = ntfy_auth(),
  username = ntfy_username(),
  password = ntfy_password(),
  ...
)
}
\arguments{
\item{x}{expression to be evaluated and timed}

\item{message}{text to send as notification}

\item{title}{title of notification. See \url{https://docs.ntfy.sh/publish/#message-title}}

\item{tags}{text tags or emoji shortcodes from \url{https://docs.ntfy.sh/emojis/},
provided as a list}

\item{topic}{subscribed topic to which to send notification}

\item{server}{ntfy server}

\item{auth}{logical indicating if the topic requires password authorization}

\item{username}{username with access to a protected topic.}

\item{password}{password with access to a protected topic.}

\item{...}{other arguments passed to \code{\link[=ntfy_send]{ntfy_send()}}}
}
\value{
the result of evaluating x (for further piping) plus a notification will be sent
}
\description{
Notify Completion of a Process with Timing
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# report that a process has completed, and how long it took
Sys.sleep(3) |> ntfy_done_with_timing()
\dontshow{\}) # examplesIf}
}
