% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{function_}
\alias{function_}
\alias{arglist}
\title{Explicitly create closures.}
\usage{
function_(args, body, env = arg_env(args, environment()))

arglist(names, fill = missing_value())
}
\arguments{
\item{args}{The argument list of the new function. NULL is accepted
to make a function with no arguments. Arguments are specified as
a named list; the list names become the argument names, and the
list values become the default expressions. A value of
\code{\link[=missing_value]{missing_value()}} indicates no default. \link{alist} and \link{arglist} are
useful for making argument lists.}

\item{body}{An expression for the body of the function.}

\item{env}{The enclosing environment of the new function.}

\item{names}{A character vector.}

\item{fill}{The expression (default missing)}
}
\value{
A closure.
}
\description{
\code{function_} is a normally-evaluating version of \code{\link{function}}, which
creates closures. A closure object has three components: the
argument list the body expression, and the enclosing environment.

\code{arglist} is a helper that produces a named list of
\link{missing_value}s given a character vector of names.
}
\examples{
f1 <- function(x, y = x) { x + y }
f2 <- function_(alist(x = , y = x),
                quote( { x + y } ),
                environment())
identical(f1, f2) # TRUE

# `fn` makes a compact way to write functions;
# `fn(x+y)` is equivalent to `function(x, y) x+y`
fn <- function(exp) {
  exp_ <- arg(exp)
  nn <- arglist(all.names(expr(exp_), functions=FALSE))
  function_(nn, expr(exp_), env(exp_))
}

fn(x^2)
fn(x+y)
}
\seealso{
environment formals body
}
