% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPotentialParents.R
\name{getPotentialParents}
\alias{getPotentialParents}
\title{Get the lists of portential parents for all individuals born in the colony
with one or two unknown parents.}
\usage{
getPotentialParents(ped, minParentAge, maxGestationalPeriod)
}
\arguments{
\item{ped}{the pedigree information in data.frame format. Pedigree
(req. fields: id, sire, dam, gen, population).
This requires complete pedigree information.}

\item{minParentAge}{numeric values to set the minimum age in years for
an animal to have an offspring. Defaults to 2 years. The check is not
performed for animals with missing birth dates.}

\item{maxGestationalPeriod}{integer value describing the days between
conception and birth. This will be used to prevent the removal of sires
who exit the colony between date of conception and birth. Need to decide
where this will come from.}
}
\value{
a list of list with each internal list being made up of an animal
id (\code{id}), a vector of possible sires (\code{sire}) and a vector of
possible dams (\code{dam}). The \code{id} must be defined while the
vectors \code{sire} and \code{dam} can be empty.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
