% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderReport.R
\name{orderReport}
\alias{orderReport}
\title{Order the results of the genetic value analysis for use in a report.}
\usage{
orderReport(rpt, ped)
}
\arguments{
\item{rpt}{a dataframe with required colnames \code{id}, \code{gu},
\code{zScores}, \code{import}, \code{totalOffspring}, which is
a data.frame of results from a genetic value analysis.}

\item{ped}{the pedigree information in datatable format with required
colnames \code{id}, \code{sire}, \code{dam}, \code{gen}, \code{population}).
This requires complete pedigree information..}
}
\value{
A dataframe, which is \code{rpt} sorted according to the ranking
scheme:
\itemize{
 \item imported animals with no offspring
 \item animals with genome uniqueness above 10%, ranked by descending gu
 \item animals with mean kinship less than 0.25, ranked by ascending mk
 \item all remaining animals, ranked by ascending mk
}
}
\description{
Part of Genetic Value Analysis
}
\details{
Takes in the results from a genetic value analysis and orders the report
according to the ranking scheme we have developed.
}
