% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paket_nph_1-9.R
\name{logrank.maxtest}
\alias{logrank.maxtest}
\alias{print.wlogrank_max}
\title{Maximum log-rank test}
\usage{
logrank.maxtest(
  time,
  event,
  group,
  alternative = c("two.sided", "less", "greater"),
  rho = c(0, 0, 1),
  gamma = c(0, 1, 0),
  weights = NULL
)
}
\arguments{
\item{time}{Vector of observed event/censored times}

\item{event}{logical vector indicating if an event was observed (TRUE) or the time is censored (FALSE)}

\item{group}{Vector of group allocations}

\item{alternative}{Either of \code{"two.sided"},\code{"less"} or \code{"greater"}, specifies if two-sided or respective
one-sided p-values are calculated. In any case the z test statistic of each included weighted log-rank test 
is based on the (weighted) sum of expected minus observed
events in the group corresponding to the first factor level of \code{group}. Hence a small value of the test statistic corresponds to a 
lower (weighted average) hazard rate in the first group.}

\item{rho}{Vector of parameter values rho for a set of weighting functions in the rho-gamma family}

\item{gamma}{Vector of parameter values gamma for a set of weighting functions in the rho-gamma family}

\item{weights}{Optional matrix, each column containing a different weighting vector for the data}
}
\value{
A list with elements:
\describe{
\item{\code{pmult}}{The two sided p-value for the null hypothesis of equal hazard functions in both groups, based on the multivariate 
normal approximation for the z-statistics of differently weighted log-rank tests.}
\item{\code{p.Bonf}}{The two sided p-value for the null hypothesis of equal hazard functions in both groups, based on a
	Bonferroni multiplicity adjustment for differently weighted log-rank tests.}
\item{\code{tests}}{Data frame with z-statistics and two-sided unadjusted p-values of the individual weighted log-rank tests}
\item{\code{korr}}{Estimated correlation matrix for the z-statistics of the differently weighted log-rank tests.}
}
}
\description{
Calculates a test for the comparison of two groups based on the maximum of test statistics of a set of weighted log-rank tests
}
\details{
To perform a maximum-type combination test, a set of \eqn{m} different weight 
functions \eqn{w_1(t), \dots, w_m(t)} is specified and the correspondingly
weighted logrank statistics \eqn{z_1,\dots,z_m} are calculated. The maximum
test statistic is \eqn{z_{max}=\max_{i=1,\dots,m} z_i}. If at least one of
the selected weight functions results in high power, we may expect a large
value of \eqn{z_{max}}. 
Under the least favorable configuration in \eqn{H_0}, approximately
\eqn{(Z_1,\dots,Z_m)\sim N_m({0},{\Sigma})}. The p-value of the maximum 
test, \eqn{P_{H_0}(Z_{max}>z_{max})=1-P(Z_1 \leq z_{max},\dots,Z_m \leq z_{max})},
is calculated based on this multivariate normal approximation via numeric integration.

This approach automatically corrects for multiple testing with different 
weights and does so efficiently since the correlation between the different 
tests is incorporated in \eqn{{\Sigma}}. For actual calculations, \eqn{{\Sigma}} is
 replaced by an estimate.
 Note that \eqn{cov (w_i(t)d_{t,ctr},w_j(t)d_{t,ctr})=w_i(t)w_j(t) var(d_{t,ctr})},
 at least approximately assuming weights are converging in probability to 
 a non-random function. Thus the \eqn{i,j}-the element of \eqn{{\Sigma}} is estimated as
 \deqn{\hat{cov}(Z_i,Z_j)=\sum_{t \in \mathcal{D}}  w_i(t)w_j(t)var(d_{t,ctr})/ \sqrt{\sum_{t \in \mathcal{D}}  w_i^2(t) var(d_{t,ctr})   \sum_{t \in \mathcal{D}} w_j^2(t) var(d_{t,ctr})}}
}
\examples{
A <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.2, 0.6, 0.2), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.4, 0.4), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
B <- pop_pchaz(Tint = c(0, 90, 1500),
  lambdaMat1 = matrix(c(0.2, 0.1, 0.4, 0.1), 2, 2) / 365,
 lambdaMat2 = matrix(c(0.5, 0.1, 0.6, 0.1), 2, 2) / 365,
 lambdaProg = matrix(c(0.5, 0.5, 0.04, 0.04), 2, 2) / 365,
 p = c(0.8, 0.2), 
 timezero = FALSE, discrete_approximation = TRUE)
dat <- sample_fun(A, B, r0 = 0.5, eventEnd = 30,
  lambdaRecr = 0.5, lambdaCens = 0.25 / 365,
 maxRecrCalendarTime = 2 * 365,
 maxCalendar = 4 * 365)
logrank.maxtest(dat$y, dat$event, dat$group)

}
\seealso{
\code{\link{logrank.test}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
