% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobato_test.R
\name{lobato.test}
\alias{lobato.test}
\title{The asymptotic Lobato and Velasco's Test for normality.}
\usage{
lobato.test(y,c = 1)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{c}{a positive real value that identifies the total amount of values used in the
cumulative sum.}
}
\value{
A list with class \code{"h.test"} containing the following components:
 \item{statistic:}{the Lobato and Velasco's statistic.}
 \item{parameter:}{the test degrees freedoms.}
 \item{p.value:}{the p-value for the test.}
 \item{alternative:}{a character string describing the alternative hypothesis.}
 \item{method:}{a character string \dQuote{Lobato and Velasco's test}.}
 \item{data.name:}{a character string giving the name of the data.}
}
\description{
Performs the asymptotic Lobato and Velasco's test of normality for univariate time series.
Computes the p-value using the asymptotic Gamma Distribution.
}
\details{
This test  proves a normality assumption in correlated data employing the
skewness-kurtosis test statistic, but studentized by standard error estimates
that are consistent under serial dependence of the observations. The test was
proposed by \emph{Lobato, I., & Velasco, C. (2004)} and implemented by
\emph{Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
lobato.test(y)

}
\references{
Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.

Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.
}
\seealso{
\code{\link{lobato.statistic}},\code{\link{epps.test}}
}
\author{
Asael Alonzo Matamoros and Alicia Nieto-Reyes.
}
