% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_test.R
\name{random.projection}
\alias{random.projection}
\title{Generate a random projection}
\usage{
random.projection(y,shape1,shape2,seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{shape1}{an optional real value with the first shape parameters of the beta
distribution.}

\item{shape2}{an optional real value with the second shape parameters of the beta
distribution.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
a real vector with the projected stochastic process.
}
\description{
Generates a random projection of a univariate stationary stochastic process. Using
a beta(shape1,shape2) distribution.
}
\details{
Generates one random projection of a stochastic process using a beta distribution.
For more details, see: \emph{Nieto-Reyes, A.,Cuesta-Albertos, J. & Gamboa, F. (2014)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
rp.test(y)

}
\references{
Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.Result

Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.
}
\seealso{
\code{\link{lobato.test}} \code{\link{epps.test}}
}
\author{
Alicia Nieto-Reyes and Asael Alonzo Matamoros
}
