% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonmem2rx.R
\name{nonmem2rx}
\alias{nonmem2rx}
\title{Convert a NONMEM source file to a rxode model (nlmixr2-syle)}
\usage{
nonmem2rx(
  file,
  inputData = NULL,
  nonmemOutputDir = NULL,
  rename = NULL,
  tolowerLhs = TRUE,
  thetaNames = TRUE,
  etaNames = TRUE,
  cmtNames = TRUE,
  updateFinal = TRUE,
  determineError = TRUE,
  validate = getOption("nonmem2rx.validate", TRUE),
  nonmemData = FALSE,
  strictLst = FALSE,
  unintFixed = FALSE,
  extended = getOption("nonmem2rx.extended", FALSE),
  nLinesPro = 20L,
  delta = 1e-04,
  usePhi = TRUE,
  useExt = TRUE,
  useCov = TRUE,
  useXml = TRUE,
  useLst = TRUE,
  mod = ".mod",
  cov = ".cov",
  phi = ".phi",
  lst = getOption("nonmem2rx.lst", ".lst"),
  xml = ".xml",
  ext = ".ext",
  scanLines = getOption("nonmem2rx.scanLines", 50L),
  save = getOption("nonmem2rx.save", NA),
  saveTime = getOption("nonmem2rx.saveTime", 15),
  overwrite = getOption("nonmem2rx.overwrite", TRUE),
  load = getOption("nonmem2rx.load", TRUE),
  compress = getOption("nonmem2rx.compress", TRUE),
  keep = getOption("nonmem2rx.keep", c("dfSub", "dfObs", "thetaMat", "sigma"))
)
}
\arguments{
\item{file}{NONMEM run file, like an \code{.xml} or \code{.lst} file or even
a control stream}

\item{inputData}{this is a path to the input dataset (or \code{NULL} to
determine from the dataset).  Often the input dataset may be
different from the place it points to in the control stream
because directories can be created to run NONMEM from a script.
Because of this, when this is specified the input data will be
assumed to be from here instead.}

\item{nonmemOutputDir}{This is a path the the nonmem output
directory.  When not \code{NULL} it will assume that the diretory for
the output files is located here instead of where the control
stream currently exists.}

\item{rename}{When not \code{NULL} this should be a named character
vector that contains the parameters that should be renamed.  For
example, if the model uses the variable \code{YTYPE} and has \code{CMT} it
isn't compatible with \code{rxode2}/\code{nlmixr2}. You can change this for
the input dataset and the model to create a new model that still
reproduces the NONMEM output by specifying
\code{rename=c(dvid="YTYPE")}}

\item{tolowerLhs}{Boolean to change the lhs to lower case (default:
\code{TRUE})}

\item{thetaNames}{this could be a boolean indicating that the theta
names should be changed to the comment-labeled names (default:
\code{TRUE}). This could also be a character vector of the theta names
(in order) to be replaced.}

\item{etaNames}{this could be a boolean indicating that the eta
names should be changed to the comment-labeled names (default:
\code{TRUE}). This could also be a character vector of the theta names
(in order) to be replaced.}

\item{cmtNames}{this could be a boolean indicating that the
compartment names should be changed to the named compartments in
the \verb{$MODEL} by \code{COMP = (name)} (default: \code{TRUE}). This could
also be a character vector of the compartment names (in order) to
be replaced.}

\item{updateFinal}{Update the parsed model with the model estimates
from the \code{.lst} output file.}

\item{determineError}{Boolean to try to determine the \code{nlmixr2}-style residual
error model (like \code{ipred ~ add(add.sd)}), otherwise endpoints are
not defined in the \code{rxode2}/\code{nlmixr2} model (default: \code{TRUE})}

\item{validate}{Boolean that this tool will attempt to "validate"
the model by solving the derived model under pred conditions
(etas are zero and eps values are zero)}

\item{nonmemData}{Boolean that tells \code{nonmem2rx} to read in the
nonmem data (if possible) even if the model will not be validated
(like if it is a simulation run or missing final parameter
estimates).  By default this is \code{FALSE}, nonmem data will not be
integrated into the nonmem2rx ui.}

\item{strictLst}{The list parsing needs to be correct for a
successful load (default \code{FALSE}).}

\item{unintFixed}{Treat uninteresting values as fixed parameters (default \code{FALSE})}

\item{extended}{Translate extended control streams from tools like
wings for NONMEM}

\item{nLinesPro}{The number of lines to check for the $PROBLEM
statement.}

\item{delta}{this is the offset for NONMEM times that are tied}

\item{usePhi}{if present, use the NONMEM phi file to extract etas
(default \code{TRUE}), otherwise defaults to etas in the tables (if
present)}

\item{useExt}{if present, use the NONMEM ext file to extract
parameter estimates (default \code{TRUE}), otherwise defaults to
parameter estimates extracted in the NONMEM output}

\item{useCov}{if present, use the NONMEM cov file to import the
covariance, otherwise import the covariance with list file}

\item{useXml}{if present, use the NONMEM xml file to import much of
the NONMEM information}

\item{useLst}{if present, use the NONMEM lst file to extract NONMEM
information}

\item{mod}{the NONMEM output extension, defaults to \code{.mod}}

\item{cov}{the NONMEM covariance file extension, defaults to \code{.cov}}

\item{phi}{the NONMEM eta/phi file extension, defaults to \code{.phi}}

\item{lst}{the NONMEM output extension, defaults to \code{.lst}}

\item{xml}{the NONMEM xml file extension , defaults to \code{.xml}}

\item{ext}{the NONMEM ext file extension, defaults to \code{.ext}}

\item{scanLines}{number of lines to scan for comment chars when
\verb{IGNORE=@}, default is 50}

\item{save}{This can be:
\itemize{
\item a \code{NULL} (meaning don't save),
\item a logical (default \code{FALSE}, don't save) that when \code{TRUE} will use
the base name of the control stream, append \code{.qs} and save the file
using \code{qs::qsave()}
\item A path to a file to write

Note that this file will be saved with qs::qsave() and can be
loaded with qs::qread()
\item A \code{NA} value which means save if the whole process (including
validation) takes too much time
}}

\item{saveTime}{The time that the translation/validation needs (in
secs) before it will save to avoid having to rerun the model
(default 15 for 15 seconds)}

\item{overwrite}{is a boolean to allow overwriting the save file
(see \code{load} for more information).}

\item{load}{a boolean that says to load the save file (if it
exists) instead of re-running the translation and validation.
Note if \code{overwrite=TRUE} and \code{load=TRUE} then this will overwrite
based on time stamp of the files.  If the save file is newer than
the input file, then load that file, otherwise regenerate and
overwrite.  This works best if you point to an output file, like
a \code{.xml} or listing file instead of the control stream}

\item{compress}{a boolean indicating if the UI should be a
compressed UI.  If you are using this for simulation with old
versions of rxode2, the compressed ui is not supported, so this
should be \code{FALSE}. Otherwise use \code{TRUE} if you are using a newer
rxode2.}

\item{keep}{is a character vector of imported model items that are
kept in the model itself; The defaults is "sigma" which keeps the
sigma matrix in the model itself.  You can add rxode2 solving
options that are imported from NONMEM to keep in the model.}
}
\value{
rxode2 function
}
\description{
Convert a NONMEM source file to a rxode model (nlmixr2-syle)
}
\details{
Since some of these options you may want to set per project, the
following options are queried:
\itemize{
\item \code{nonmem2rx.validate} - boolean to validate the model (default: \code{TRUE})
\item \code{nonmem2rx.lst} - default extension for output (default: \code{.lst})
\item \code{nonmem2rx.save} - should nonmem2rx save the model output?
\item \code{nonmem2rx.overwrite} - should nonmem2rx save output be
overwritten (default \code{TRUE})
\item \code{nonmem2rx.load} - should nonmem2rx load a saved model instead of
translating and validating again? (default \code{TRUE})
\item \code{nonmem2rx.extended} - should nonmem2rx support extended control
streams? (default \code{FALSE})
\item \code{nonmem2rx.compress} - should the ui be compressed or
uncompressed (default: \code{TRUE})
}
}
\examples{

# You can run a translation without validating the input.  This is
# a faster way to import a dataset (and allows the CRAN machines to
# run a quick example)

mod <- nonmem2rx(system.file("mods/cpt/runODE032.ctl", package="nonmem2rx"), lst=".res",
                save=FALSE, validate=FALSE, compress=FALSE)

\donttest{

# Though by default you likely wish to validate the input

mod <- nonmem2rx(system.file("mods/cpt/runODE032.ctl", package="nonmem2rx"),
                 lst=".res", save=FALSE)

mod

# you can plot to compare the pred/ipred differences

plot(mod)

# if you want to see the individual differences
# you can by plotting by page of plots

plot(mod, nrow=2, ncol=2, page=1, log="y")

# or select which pages you want to print

plot(mod, nrow=2, ncol=2, page=c(1,3), log="y")


#' or even  all the individuals with
# plot(page=TRUE)

plot(mod, nrow=5, ncol=5, page=TRUE, log="y")

# you can also convert to a nlmixr2 object, but need babelmixr2 for
# that conversion

}

}
