% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin.R
\name{lin}
\alias{lin}
\title{Lin (LIN) Measure}
\usage{
lin(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns an object of class "dist".
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the LIN similarity measure.
}
\details{
The Lin measure was introduced by Lin (1998) and presented in (Boriah et al., 2008).
The measure assigns higher weights to more frequent categories in case of matches
and lower weights to less frequent categories in case of mismatches.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.lin <- lin(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Lin D. (1998). An information-theoretic definition of similarity.
In: ICML '98: Proceedings of the 15th International Conference on Machine Learning. San Francisco, p. 296-304.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
