% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_events.R
\name{find_events}
\alias{find_events}
\title{Find all event listings for date range}
\usage{
find_events(date_range = NULL, event_types = NULL, dist_limit = NULL,
  storm = NULL, include_narratives = FALSE, include_ids = FALSE,
  clean_damage = FALSE)
}
\arguments{
\item{date_range}{A character vector of length two with the start and end
dates to pull data for (e.g., \code{c("1999-10-16", "1999-10-18")}).}

\item{event_types}{Character vector with the types of storm events that should be kept.
The default value (NULL) keeps all types of events. See the "Details" vignette for this
package for more details on possible event types.}

\item{dist_limit}{A numeric scalar with the distance (in kilometers) that a county
must be from the storm's path to be included. The default (NULL) does not eliminate any
events based on distance from a storm's path. This option should only be used when also
specifying a storm with the \code{storm} parameter.}

\item{storm}{A character string with the name of the storm to pull storm
events data for. This string must follow the format
"[storm-name]-[4-digit storm year]" (e.g., \code{"Floyd-1999"}).
Currently, this functionality only works for storms included in the
extended hurricane best tracks, which covers 1988 to 2015.}

\item{include_narratives}{A logical value for whether the final data
data frame should include columns for episode and event narratives
(TRUE) or not (FALSE, the default)}

\item{include_ids}{A logical value for whether the final data frame
should include columns for event and episode IDs (TRUE) or not
(FALSE, the default). If included, these IDs could be used in some
cases to link events to data in the "fatalities" or "locations"
files available through the NOAA Storm Events database.}

\item{clean_damage}{TRUE / FALSE of whether additional cleaning should be
done to try to exclude incorrect damage listings. If TRUE, any property
or crop damages for which the listing for that single event exceeds all
other damages in the state combined for the event dataset, the damages for
that event listing will be set to missing. Default is FALSE (i.e., this
additional check is not performed). In some cases, it seems that a single
listing by forecast zone gives the state total for damages, and this option
may help in identifying and excluding such listings (for example, one listing in
North Carolina for Hurricane Floyd seems to be the state total for damages, rather
than a county-specific damage estimate).}
}
\description{
This function will find all of the events in the US for a specified date
range.
}
\examples{
\dontrun{
# Events by date range
find_events(date_range = c("1999-09-10", "1999-09-30"))

# Events within a certain distance and time range of a tropical storm
find_events(storm = "Floyd-1999", dist_limit = 200)

# Limit output to events that are floods or flash floods
find_events(storm = "Floyd-1999", dist_limit = 200, event_types = c("Flood", "Flash Flood"))
}

}
