% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVR.confint.r
\encoding{UTF-8}
\name{PVR.confint}
\alias{PVR.confint}
\title{Pseudo Variance Modification of Rubin's Rule}
\usage{
PVR.confint(obj, variable, skewbeta = FALSE)
}
\arguments{
\item{obj}{A fitted \code{logisf} object}

\item{variable}{The variable(s) to compute the PVR confidence intervals, either provided as names or as numbers}

\item{skewbeta}{If \code{TRUE}, incorporates information on the skewness of the parameter estimates
across the imputed data sets.}
}
\value{
An object of class \code{PVR.confint} with items:
  \item{estimate}{the pooled parameter estimate(s) (the average across completed-data estimates)}
  \item{ci}{the confidence intervals based on the PVR method}
  \item{lower.var}{the lower pseudo-variance(s)}
  \item{upper.var}{the upper pseudo-variance(s)}
  \item{conflev}{the confidence level: this is determined by the confidence level (1-alpha) used in the input fit objects}
  \item{call}{the function call}
  \item{variable}{the variable(s) for which confidence intervals were computed}
}
\description{
The pseudo-variance modification proposed by Heinze, Ploner and Beyea (2013) provides a quick
way to adapt Rubin's rules to situations of a non-normal distribution of a regression coefficient.
However, the approximation is less accurate than that of the CLIP method.
}
\details{
The pseudo-variance modification computes a lower and an upper pseudo-variance, which are based
on the distance between profile likelihood limits and the parameter estimates. These are then
plugged into the usual Rubin's rules method of variance combination
}
\examples{
#generate data set with NAs
freq=c(5,2,2,7,5,4)
y<-c(rep(1,freq[1]+freq[2]), rep(0,freq[3]+freq[4]), rep(1,freq[5]), rep(0,freq[6]))
x<-c(rep(1,freq[1]), rep(0,freq[2]), rep(1,freq[3]), rep(0,freq[4]), rep(NA,freq[5]),
   rep(NA,freq[6]))
toy<-data.frame(x=x,y=y)

# impute data set 5 times
set.seed(169)
toymi<-list(0)
for(i in 1:5){
  toymi[[i]]<-toy
  y1<-toymi[[i]]$y==1 & is.na(toymi[[i]]$x)
  y0<-toymi[[i]]$y==0 & is.na(toymi[[i]]$x)
  xnew1<-rbinom(sum(y1),1,freq[1]/(freq[1]+freq[2]))
  xnew0<-rbinom(sum(y0),1,freq[3]/(freq[3]+freq[4]))
  toymi[[i]]$x[y1==TRUE]<-xnew1
  toymi[[i]]$x[y0==TRUE]<-xnew0
  }

# logistf analyses of each imputed data set
fit.list<-lapply(1:5, function(X) logistf(data=toymi[[X]], y~x, pl=TRUE, dataout=TRUE))

# CLIP confidence limits
PVR.confint(obj=fit.list)

}
\references{
Heinze G, Ploner M, Beyea J (2013). Confidence intervals after multiple imputation: combining
profile likelihood information from logistic regressions. Statistics in Medicine, to appear.
}
\author{
Georg Heinze
}
