% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmslib.R
\name{dgCMatrix_2scipy_sparse}
\alias{dgCMatrix_2scipy_sparse}
\title{conversion of an R dgCMatrix to a scipy sparse matrix}
\usage{
dgCMatrix_2scipy_sparse(dgc_mat_object)
}
\arguments{
\item{dgc_mat_object}{an R sparse matrix of type \emph{dgCMatrix}}
}
\description{
conversion of an R dgCMatrix to a scipy sparse matrix
}
\details{
This function allows the user to convert an R \emph{dgCMatrix} to a scipy sparse matrix (\emph{scipy.sparse.csc_matrix}). This is useful because the \emph{nmslibR} package accepts besides an R dense matrix also python sparse matrices as input.

The dgCMatrix class is a class of sparse numeric matrices in the compressed, sparse, \emph{column-oriented format}. In this implementation the non-zero elements in the columns are sorted into increasing row order. dgCMatrix is the “standard” class for sparse numeric matrices in the \emph{Matrix} package.
}
\examples{

if (reticulate::py_available() && reticulate::py_module_available("scipy")) {

  library(nmslibR)

  data = c(1, 0, 2, 0, 0, 3, 4, 5, 6)

  dgcM = Matrix::Matrix(data = data, nrow = 3,

                        ncol = 3, byrow = TRUE,

                        sparse = TRUE)

  print(dim(dgcM))

  res = dgCMatrix_2scipy_sparse(dgcM)

  print(res$shape)
}
}
\references{
https://stat.ethz.ch/R-manual/R-devel/library/Matrix/html/dgCMatrix-class.html, https://docs.scipy.org/doc/scipy/reference/generated/scipy.sparse.csc_matrix.html#scipy.sparse.csc_matrix
}
