% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/006functions.R
\name{addInter}
\alias{addInter}
\title{Add interactions}
\usage{
addInter(eqcont, par_c, intv, inter_parl)
}
\arguments{
\item{eqcont}{Vector of strings containing equations.}

\item{par_c}{Names of coefficients.}

\item{intv}{Vector of integers corresponding to coefficients to which interactions
should be added.}

\item{inter_parl}{Names of new coefficients (interactions).}
}
\value{
list: 1 - expressions of errors, equations, parameters to estimate
}
\description{
\code{addInter} add interactions into continuous equations.
}
\examples{
eq_c <- c("Tw ~ tw*w + ph1*Tc", "Tf1 ~ (1+w)^tw + ph1^3*Tc")
parl <- c("tw", "ph1")
intv <- c(1,0)
inter_parl <- c('yytw','yyph1')
res <- addInter(eq_c, parl, intv, inter_parl)
}
