% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_morris}
\alias{simdesign_morris}
\title{Add a morris elementary effects simdesign to a nl object}
\usage{
simdesign_morris(nl, morristype, morrislevels, morrisr, morrisgridjump, nseeds)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{morristype}{morris design type}

\item{morrislevels}{number of parameter levels}

\item{morrisr}{morris r value}

\item{morrisgridjump}{morris grid jump value}

\item{nseeds}{number of seeds for this simulation design}
}
\value{
simdesign S4 class object
}
\description{
Add a morris elementary effects simdesign to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.

Variables in the experiment variable list need to provide a numeric distribution with min, max and qfun (e.g. list(min=1, max=4, qfun="qunif")).

The morris simdesign uses the sensitivity package to set up a morris elementary effects sensitivity analysis, including a simobject of class morris and a input tibble for simulations.
For details on method specific sensitivity analysis function parameters see ?morris
Finally, the function reports a simdesign object.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_morris
nl@simdesign <- simdesign_morris(nl=nl,
                                  morristype="oat",
                                  morrislevels=4,
                                  morrisr=20,
                                  morrisgridjump=2,
                                  nseeds=3)


}
