% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nixtla_client_plot.R
\name{nixtla_client_plot}
\alias{nixtla_client_plot}
\title{Plot the output of the following nixtla_client functions: forecast, historic, anomaly_detection, and cross_validation.}
\usage{
nixtla_client_plot(
  df,
  fcst = NULL,
  h = NULL,
  id_col = NULL,
  time_col = "ds",
  target_col = "y",
  unique_ids = NULL,
  max_insample_length = NULL,
  plot_anomalies = FALSE
)
}
\arguments{
\item{df}{A tsibble or a data frame with time series data (insample values).}

\item{fcst}{A tsibble or a data frame with the 'TimeGPT' point forecast and the prediction intervals (if available).}

\item{h}{Forecast horizon.}

\item{id_col}{Column that identifies each series.}

\item{time_col}{Column that identifies each timestep.}

\item{target_col}{Column that contains the target variable.}

\item{unique_ids}{Time series to plot. If NULL (default), selection will be random.}

\item{max_insample_length}{Max number of insample observations to be plotted.}

\item{plot_anomalies}{Whether or not to plot anomalies.}
}
\value{
Plot with historical data and 'TimeGPT''s output (if available).
}
\description{
Plot the output of the following nixtla_client functions: forecast, historic, anomaly_detection, and cross_validation.
}
\examples{
\dontrun{
  nixtlar::nixtla_set_api_key("YOUR_API_KEY")
  df <- nixtlar::electricity
  fcst <- nixtlar::nixtla_client_forecast(df, h=8, id_col="unique_id", level=c(80,95))
  nixtlar::timegpt_plot(df, fcst, h=8, id_col="unique_id")
}

}
