% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_metadata_field}
\alias{get_metadata_field}
\alias{get_metadata}
\title{Get metadata}
\usage{
get_metadata_field(x, field)

get_metadata(x)
}
\arguments{
\item{x}{A \link{nisra_df} object created using \code{\link[=nisra_read_dataset]{nisra_read_dataset()}}}

\item{field}{The metadata field to read. See details for a list of fields.}
}
\value{
Metadata if the field is found, otherwise \code{NULL}
}
\description{
Retrieve metadata from a dataset, such as contact information, notes, and
official statistics status.
}
\details{
Every dataset should have the following metadata fields:
\itemize{
\item contact - contact name, email and phone
\item copyright - copyright information
\item experimental - a flag for experimental statistics
\item note - any notes describing the data
\item official - a flag for official statistics
\item subject - a code and label for the subject
\item updated - date
}
}
\examples{
mye <- nisra_read_dataset("MYE01T09")
get_metadata(mye)
get_metadata_field(mye, "contact")
}
