% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e09630446aa
\name{Multinomial}
\alias{Multinomial}
\alias{dmulti}
\alias{multinomial}
\alias{rmulti}
\title{The Multinomial Distribution}
\usage{
dmulti(x, size = sum(x), prob, log = FALSE)

rmulti(n = 1, size, prob)
}
\arguments{
\item{x}{vector of values.}

\item{size}{number of trials.}

\item{prob}{vector of probabilities, internally normalized to sum to one, of same length as \code{x}}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only \code{n=1} is handled currently).}
}
\value{
\code{dmulti} gives the density and \code{rmulti} generates random deviates.
}
\description{
Density and random generation for the multinomial distribution
}
\details{
See Gelman et al., Appendix A or the BUGS manual for mathematical details.
}
\examples{
size <- 30
probs <- c(1/4, 1/10, 1 - 1/4 - 1/10)
x <- rmulti(1, size, probs)
dmulti(x, size, probs)
}
\author{
Christopher Paciorek
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

