% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{nimEigen}
\alias{eigen}
\alias{nimEigen}
\title{Spectral Decomposition of a Matrix}
\usage{
nimEigen(x, symmetric = FALSE, only.values = FALSE)
}
\arguments{
\item{x}{a  numeric matrix (double or integer) whose spectral decomposition is to be computed.}

\item{symmetric}{if \code{TRUE}, the matrix is guarranteed to be symmetric, and only its lower triangle (diagonal included) is used.  Otherwise, the matrix
is checked for symmetry.  Default is \code{FALSE}.}

\item{only.values}{if \code{TRUE}, only the eigenvalues are computed, otherwise both eigenvalues and eigenvectors are computed. 
Setting \code{only.values = TRUE} can speed up eigendecompositions, especially for large matrices.  Default is \code{FALSE}.}
}
\value{
The spectral decomposition of \code{x} is returned as a \code{\link{nimbleList}} with elements:
\itemize{
\item values vector containing the eigenvalues of \code{x}, sorted in decreasing order.  Since \code{x} is required to be symmetric, all eigenvalues will be real numbers.
\item vectors. matrix with columns containing the eigenvectors of \code{x}, or an empty matrix if \code{only.values} is \code{TRUE}.
}
}
\description{
Computes eigenvalues and eigenvectors of a numeric matrix.
}
\details{
Computes the spectral decomposition of a numeric matrix using the Eigen C++ template library. 
In a nimbleFunction, \code{eigen} is identical to \code{nimEigen}.  If the matrix is symmetric, a faster and more accurate algorithm will be used to compute the eigendecomposition. Note that non-symmetric matrices can have complex eigenvalues,
which are not supported by NIMBLE.  If a complex eigenvalue or a complex element of an eigenvector is detected, a warning will be issued and that element will be returned as \code{NaN}.

Additionally, \code{returnType(eigenNimbleList())} can be used within a \code{link{nimbleFunction}} to specify that the function will return a \code{\link{nimbleList}} generated by the \code{nimEigen} function.  \code{eigenNimbleList()} can also be used to define a nested \code{\link{nimbleList}} element.  See the User Manual for usage examples.
}
\examples{
eigenvaluesDemoFunction <- nimbleFunction(
   setup = function(){
     demoMatrix <- diag(4) + 2
   },
   run = function(){
     eigenvalues <- eigen(demoMatrix, symmetric = TRUE)$values
     returnType(double(1))
     return(eigenvalues)
 })

}
\author{
NIMBLE development team
}
\seealso{
\code{\link{nimSvd}} for singular value decompositions in NIMBLE.
}

