% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{Inverse-Gamma}
\alias{Inverse-Gamma}
\alias{dinvgamma}
\alias{rinvgamma}
\alias{pinvgamma}
\alias{qinvgamma}
\title{The Inverse Gamma Distribution}
\usage{
dinvgamma(x, shape, scale = 1, rate = 1/scale, log = FALSE)

rinvgamma(n = 1, shape, scale = 1, rate = 1/scale)

pinvgamma(
  q,
  shape,
  scale = 1,
  rate = 1/scale,
  lower.tail = TRUE,
  log.p = FALSE
)

qinvgamma(
  p,
  shape,
  scale = 1,
  rate = 1/scale,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{x}{vector of values.}

\item{shape}{vector of shape values, must be positive.}

\item{scale}{vector of scale values, must be positive.}

\item{rate}{vector of rate values, must be positive.}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default) probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given by user as log(p).}

\item{p}{vector of probabilities.}
}
\value{
\code{dinvgamma} gives the density, \code{pinvgamma} gives the distribution
function, \code{qinvgamma} gives the quantile function, and \code{rinvgamma}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random
  generation for the inverse gamma distribution with rate
    or scale (mean = scale / (shape - 1)) parameterizations.
}
\details{
The inverse gamma distribution with parameters \code{shape} \eqn{=\alpha}{= a} and
\code{scale} \eqn{=\sigma}{= s} has density
\deqn{
  f(x)= \frac{s^a}{\Gamma(\alpha)} {x}^{-(\alpha+1)} e^{-\sigma/x}%
 }{f(x)= (s^a / Gamma(a)) x^-(a+1) e^-(s/x)}
for \eqn{x \ge 0}, \eqn{\alpha > 0}{a > 0} and \eqn{\sigma > 0}{s > 0}.
(Here \eqn{\Gamma(\alpha)}{Gamma(a)} is the function implemented by \R's
 \code{\link{gamma}()} and defined in its help.

 The mean and variance are
 \eqn{E(X) = \frac{\sigma}{\alpha}-1}{E(X) = s/(a-1)} and
\eqn{Var(X) = \frac{\sigma^2}{(\alpha-1)^2 (\alpha-2)}}{Var(X) = s^2 / ((a-1)^2 * (a-2))},
with the mean defined only
for \eqn{\alpha > 1}{a > 1} and the variance only for \eqn{\alpha > 2}{a > 2}.

See Gelman et al., Appendix A or
the BUGS manual for mathematical details.
}
\examples{
x <- rinvgamma(50, shape = 1, scale = 3)
dinvgamma(x, shape = 1, scale = 3)
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}
\author{
Christopher Paciorek
}
