% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDMI.R
\name{NDMI}
\alias{NDMI}
\title{NDMI - Normalized Difference Moisture Index}
\usage{
NDMI(NIR, SWIR)
}
\arguments{
\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}

\item{SWIR}{A raster layer object with the reflectance values for the Short Wave Infrared band.}
}
\value{
NDMI - Normalized Difference Moisture Index.
}
\description{
NDMI is used to determine vegetation water content.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
NDMI(x[[5]], x[[6]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
