% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_oaproc.R
\name{get_xs_points}
\alias{get_xs_points}
\title{Get Cross Section Endpoints (experimental)}
\usage{
get_xs_points(point1, point2, num_pts, res = 1)
}
\arguments{
\item{point1}{sfc POINT including crs as created by:
\code{sf::st_sfc(sf::st_point(.. ,..), crs)}}

\item{point2}{sfc POINT including crs.}

\item{num_pts}{numeric number of points to retrieve along the cross section.}

\item{res}{integer resolution of 3D Elevation Program data to request.
Must be on of: 1, 3, 5, 10, 30, 60.}
}
\value{
sf data.frame containing points retrieved.
}
\description{
Uses a cross section retrieval web services to retrieve a
cross section between two endpoints.
}
\examples{
\donttest{
point1 <- sf::st_sfc(sf::st_point(x = c(-105.9667, 36.17602)), crs = 4326)
point2 <- sf::st_sfc(sf::st_point(x = c(-105.97768, 36.17526)), crs = 4326)

(xs <- get_xs_points(point1, point2, 100))

bbox <- sf::st_bbox(xs) + c(-0.005, -0.005, 0.005, 0.005)

nhdplusTools::plot_nhdplus(bbox = bbox, cache_data = FALSE)

plot(sf::st_transform(sf::st_geometry(xs), 3857), pch = ".", add = TRUE, col = "red")
plot(sf::st_transform(sf::st_sfc(point1, crs = 4326), 3857), add = TRUE)
plot(sf::st_transform(sf::st_sfc(point2, crs = 4326), 3857), add = TRUE)

plot(xs$distance_m, xs$elevation_m)

}

}
