% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_nhdplus.R
\name{rescale_measures}
\alias{rescale_measures}
\title{Rescale reachcode measure to comid flowline measure.}
\usage{
rescale_measures(measure, from, to)
}
\arguments{
\item{measure}{numeric reach measure between 0 and 100}

\item{from}{numeric flowline from-measure relative to the reach}

\item{to}{numeric flowline to-measure relative to the reach}
}
\value{
numeric rescaled measure
}
\description{
Given a reachcode measure and the from and to measure for a
comid flowline, returns the measure along the comid flowline. This is
a utility specific to the NHDPlus data model where many comid flowlines make
up a single reachcode / reach. "Measures" are typically referenced to
reaches. Flowlines have a stated from-measure / to-measure. In some cases
it is useful to rescale the measure such that it is relative only to the
flowline.

from is downstream -- 0 is the outlet
to is upstream -- 100 is the inlet
}
\examples{
rescale_measures(40, 0, 50)
rescale_measures(60, 50, 100)

}
