% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_nhdplus.R
\name{get_waterbody_index}
\alias{get_waterbody_index}
\title{Get Waterbody Index}
\usage{
get_waterbody_index(waterbodies, points, flines = NULL, search_radius = 0.1)
}
\arguments{
\item{waterbodies}{sf data.frame of type POLYGON or MULTIPOLYGON including
COMID attributes.}

\item{points}{sfc of type POINT}

\item{flines}{sf data.frame of type LINESTRING or MULTILINESTRING including
COMID, WBAREACOMI, and Hydroseq attributes}

\item{search_radius}{numeric how far to search for a waterbody boundary in
units of provided projection}
}
\value{
data.frame with two columns, COMID, in_wb_COMID, near_wb_COMID,
near_wb_dist, and outlet_fline_COMID. Distance is in units of provided projection.
}
\description{
given an sf point geometry column, return waterbody id, and
COMID of dominant artificial path
}
\examples{
sample <- system.file("extdata/sample_natseamless.gpkg",
                      package = "nhdplusTools")

waterbodies <- sf::read_sf(sample, "NHDWaterbody")
get_waterbody_index(waterbodies,
                    sf::st_sfc(sf::st_point(c(-89.356086, 43.079943)),
                               crs = 4326, dim = "XY"))

}
