% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{add_2pt_probs}
\alias{add_2pt_probs}
\title{Get 2pt decision probabilities}
\usage{
add_2pt_probs(df)
}
\arguments{
\item{df}{A data frame of decisions to be computed for.}
}
\value{
Original data frame Data frame plus the following columns added:
\describe{
first_down_prob, wp_fail, wp_succeed, go_wp, fg_make_prob, miss_fg_wp, make_fg_wp, fg_wp, punt_wp
\item{wp_0}{Win probability when scoring 0 points on PAT.}
\item{wp_1}{Win probability when scoring 1 point on PAT.}
\item{wp_2}{Win probability when scoring 2 points on PAT.}
\item{conv_1pt}{Probability of making PAT kick.}
\item{conv_2pt}{Probability of converting 2-pt attempt.}
\item{wp_go1}{Win probability associated with going for 1.}
\item{wp_go2}{Win probability associated with going for 2.}
}
}
\description{
Get various probabilities associated with each option on PATs (go
for it, kick PAT).
}
\examples{
\dontshow{if (identical(data.table::getDTthreads(FALSE), 2L) || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
\donttest{
play <-
  tibble::tibble(
    # things to help find the right game (use "reg" or "post")
    home_team = "GB",
    away_team = "TB",
    posteam = "GB",
    type = "post",
    season = 2020,

    # information about the situation
    qtr = 4,
    quarter_seconds_remaining = 123,
    score_differential = -2,

    home_opening_kickoff = 0,
    posteam_timeouts_remaining = 3,
    defteam_timeouts_remaining = 3
  )

probs <- nfl4th::add_2pt_probs(play)

dplyr::glimpse(probs)
}
\dontshow{\}) # examplesIf}
}
