% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dist.R
\docType{methods}
\name{mahalanobis}
\alias{mahalanobis}
\alias{mahalanobis,CompositionMatrix-method}
\alias{mahalanobis,ILR-method}
\title{Mahalanobis Distance}
\usage{
\S4method{mahalanobis}{CompositionMatrix}(x, center, cov, ..., robust = TRUE, method = c("mve", "mcd"))

\S4method{mahalanobis}{ILR}(x, center, cov, ..., robust = TRUE, method = c("mve", "mcd"))
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} or an \code{\linkS4class{ILR}} object.}

\item{center}{A \code{\link{numeric}} vector giving the mean vector of the
distribution. If missing, will be estimated from \code{x}.}

\item{cov}{A \code{\link{numeric}} matrix giving the covariance of the
distribution. If missing, will be estimated from \code{x}.}

\item{...}{Extra parameters to be passed to \code{\link[MASS:cov.rob]{MASS::cov.rob()}}.
Only used if \code{robust} is \code{TRUE}.}

\item{robust}{A \code{\link{logical}} scalar: should robust location and scatter
estimation be used?}

\item{method}{A \code{\link{character}} string specifying the method to be used.
It must be one of "\code{mve}" (minimum volume ellipsoid) or "\code{mcd}" (minimum
covariance determinant). Only used if \code{robust} is \code{TRUE}.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Computes the squared Mahalanobis distance of all rows in \code{x}.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Mahalanobis distance
mahalanobis(coda)
}
\seealso{
\code{\link[stats:mahalanobis]{stats::mahalanobis()}}

Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
