% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nvd-class.R
\name{var_nvd}
\alias{var_nvd}
\title{Fréchet Variance of Network-Valued Data Around a Given Network}
\usage{
var_nvd(x, x0, weights = rep(1, length(x)), distance = "frobenius")
}
\arguments{
\item{x}{An \code{\link{nvd}} object listing a sample of networks.}

\item{x0}{A network already in matrix representation around which to
calculate variance (usually the Fréchet mean but not necessarily). Note
that the chosen matrix representation is extracted from this parameter.}

\item{weights}{A numeric vector specifying weights for each observation
(default: equally weighted).}

\item{distance}{A string specifying the distance to be used. Possible choices
are: hamming, frobenius, spectral or root-euclidean. Default is frobenius.
When the Fréchet mean is used as \code{x0} parameter, the distance should
match the one used to compute the mean. This is not currently checked.}
}
\value{
A positive scalar value evaluating the amount of variability of the
sample around the specified network.
}
\description{
This function computes the Fréchet variance around a specified network from
an observed sample of network-valued random variables according to a
specified distance. In most cases, the user is willing to compute the sample
variance, in which case the Fréchet variance has to be evaluated w.r.t. the
sample Fréchet mean. In this case, it is important that the user indicates
the same distance as the one (s)he used to separately compute the sample
Fréchet mean. This function can also be used as is as the function to be
minimized in order to find the Fréchet mean for a given distance.
}
\examples{
d <- nvd(n = 10L)
m <- mean(d)
var_nvd(x = d, x0 = m, distance = "frobenius")
}
