% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVector.R
\docType{methods}
\name{scaleSeries}
\alias{scaleSeries}
\alias{scaleSeries,BrainVector,logical,logical-method}
\alias{scaleSeries,BrainVector,logical,missing-method}
\alias{scaleSeries,BrainVector,missing,logical-method}
\alias{scaleSeries,BrainVector,missing,missing-method}
\title{Generic functions to scale (center and/or normalize by standard deviation) each series of a 4D image
That is, if the 4th dimension is 'time' each series is a 1D time series.}
\usage{
scaleSeries(x, center, scale)

\S4method{scaleSeries}{BrainVector,logical,logical}(x, center, scale)

\S4method{scaleSeries}{BrainVector,missing,logical}(x, center, scale)

\S4method{scaleSeries}{BrainVector,missing,missing}(x, center, scale)

\S4method{scaleSeries}{BrainVector,logical,missing}(x, center, scale)
}
\arguments{
\item{x}{a four dimensional image}

\item{center}{a \code{logical} value indicating whether series should be centered. \code{TRUE} if not specified.}

\item{scale}{a \code{logical} value indicating whether series should be divided by standard deviation. \code{TRUE} if not specified.}
}
\description{
Generic functions to scale (center and/or normalize by standard deviation) each series of a 4D image
That is, if the 4th dimension is 'time' each series is a 1D time series.
}
\examples{
bvec <- BrainVector(array(rnorm(24*24*24*24), c(24,24,24,24)), BrainSpace(c(24,24,24,24), c(1,1,1)))
res <- scaleSeries(bvec, TRUE, TRUE)
}

