% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simpleNetwork.R
\name{simpleNetwork}
\alias{simpleNetwork}
\title{Function for creating simple D3 JavaScript force directed network graphs.}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/} and,
  more specifically for directed networks
  \url{https://github.com/mbostock/d3/wiki/Force-Layout}
}
\usage{
simpleNetwork(Data, Source = NULL, Target = NULL, height = NULL,
  width = NULL, linkDistance = 50, charge = -200, fontSize = 7,
  linkColour = "#666", nodeColour = "#3182bd",
  nodeClickColour = "#E34A33", textColour = "#3182bd", opacity = 0.6)
}
\arguments{
\item{Data}{a data frame object with three columns. The first two are the
names of the linked units. The third records an edge value. (Currently the
third column doesn't affect the graph.)}

\item{Source}{character string naming the network source variable in the data
frame. If \code{Source = NULL} then the first column of the data frame is
treated as the source.}

\item{Target}{character string naming the network target variable in the data
frame. If \code{Target = NULL} then the second column of the data frame is
treated as the target.}

\item{height}{height for the network graph's frame area in pixels (if
\code{NULL} then height is automatically determined based on context)}

\item{width}{numeric width for the network graph's frame area in pixels (if
\code{NULL} then width is automatically determined based on context)}

\item{linkDistance}{numeric distance between the links in pixels (actually
arbitrary relative to the diagram's size).}

\item{charge}{numeric value indicating either the strength of the node
repulsion (negative value) or attraction (positive value).}

\item{fontSize}{numeric font size in pixels for the node text labels.}

\item{linkColour}{character string specifying the colour you want the link
lines to be. Multiple formats supported (e.g. hexadecimal).}

\item{nodeColour}{character string specifying the colour you want the node
circles to be. Multiple formats supported (e.g. hexadecimal).}

\item{nodeClickColour}{character string specifying the colour you want the
node circles to be when they are clicked. Also changes the colour of the
text. Multiple formats supported (e.g. hexadecimal).}

\item{textColour}{character string specifying the colour you want the text to
be before they are clicked. Multiple formats supported (e.g. hexadecimal).}

\item{opacity}{numeric value of the proportion opaque you would like the
  graph elements to be.}
}
\description{
\code{simpleNetwork} creates simple D3 JavaScript force directed network
graphs.
}
\examples{
# Fake data
Source <- c("A", "A", "A", "A", "B", "B", "C", "C", "D")
Target <- c("B", "C", "D", "J", "E", "F", "G", "H", "I")
NetworkData <- data.frame(Source, Target)

# Create graph
simpleNetwork(NetworkData)
}

