% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netgraph.netconnection.R
\name{netgraph.netconnection}
\alias{netgraph.netconnection}
\title{Network graph for objects of class netconnection}
\usage{
\method{netgraph}{netconnection}(x, seq, col = x$subnet.comparisons, plastic = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{netconnection}.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments arrangement (anticlockwise if \code{start.layout =
"circle"}).}

\item{col}{A single color (or vector of colors) for lines
connecting treatments (edges) if argument \code{plastic = FALSE}.}

\item{plastic}{A logical indicating whether the appearance of the
comparisons should be in '3D look'.}

\item{\dots}{Additional arguments passed on to
\code{\link{netgraph.netmeta}} (see Details).}
}
\description{
This function generates a graph of the evidence network.
}
\details{
The following arguments are used internally and cannot be specified
by the user: \code{thickness}, \code{seq}, \code{iterate}.
}
\examples{
# Artificial example with two subnetworks
#
t1 <- c("G", "B", "B", "D", "A", "F")
t2 <- c("B", "C", "E", "E", "H", "A")
#
nc1 <- netconnection(t1, t2)
print(nc1, details = TRUE)

netgraph(nc1, plastic = FALSE)

}
\seealso{
\code{\link{netconnection}}, \code{\link{netgraph.netmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de},
  Gerta Rücker \email{ruecker@imbi.uni-freiburg.de}
}
\keyword{hplot}
