% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.netimpact.R
\name{print.netimpact}
\alias{print.netimpact}
\title{Print method for objects of class netimpact}
\usage{
\method{print}{netimpact}(
  x,
  comb.fixed = x$x$comb.fixed,
  comb.random = x$x$comb.random,
  digits = gs("digits.prop"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{netimpact}.}

\item{comb.fixed}{A logical indicating whether results for the
fixed effects (common effects) model should be printed.}

\item{comb.random}{A logical indicating whether results for the
random effects model should be printed.}

\item{digits}{Minimal number of significant digits.}

\item{\dots}{Additional arguments (ignored).}
}
\description{
Print method for objects of class \code{netimpact}.
}
\examples{
data(parkinson)

# Only consider first four studies (to reduce runtime of example)
#
p1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
               n = list(n1, n2, n3),
               mean = list(y1, y2, y3),
               sd = list(sd1, sd2, sd3),
               data = subset(parkinson, Study < 5),
               studlab = Study)

net1 <- netmeta(p1)
ni <- netimpact(net1, verbose = TRUE)
ni

}
\seealso{
\code{\link{netimpact}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
