% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{dgr}
\alias{degree}
\alias{dgr}
\alias{indegree}
\alias{outdegree}
\alias{plot.diffnet_degSeq}
\title{Indegree, outdegree and degree of the vertices}
\usage{
dgr(graph, cmode = "degree", undirected = getOption("diffnet.undirected",
  FALSE), self = getOption("diffnet.self", FALSE),
  valued = getOption("diffnet.valued", FALSE))

\method{plot}{diffnet_degSeq}(x, breaks = min(100L, nrow(x)/5),
  freq = FALSE, y = NULL, log = "xy", hist.args = list(),
  slice = ncol(x), xlab = "Degree", ylab = "Freq", ...)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}

\item{cmode}{Character scalar. Either "indegree", "outdegree" or "degree".}

\item{undirected}{Logical scalar. When \code{TRUE} only the lower triangle will be processed.}

\item{self}{Logical scalar. When \code{TRUE} allows loops (self edges).}

\item{valued}{Logical scalar. When \code{TRUE} weights will be considered. Otherwise non-zero values will be replaced by ones.}

\item{x}{An \code{diffnet_degSeq object}}

\item{breaks}{Passed to \code{\link{hist}}.}

\item{freq}{Logical scalar. When \code{TRUE} the y-axis will reflex counts,
otherwise densities.}

\item{y}{Ignored}

\item{log}{Passed to \code{\link{plot}} (see \code{\link{par}}).}

\item{hist.args}{Arguments passed to \code{\link{hist}}.}

\item{slice}{Integer scalar. In the case of dynamic graphs, number of time
point to plot.}

\item{xlab}{Character scalar. Passed to \code{\link{plot}}.}

\item{ylab}{Character scalar. Passed to \code{\link{plot}}.}

\item{...}{Further arguments passed to \code{\link{plot}}.}
}
\value{
A numeric matrix of size \eqn{n\times T}{n * T}. In the case of \code{plot},
 returns an object of class \code{\link[graphics:hist]{histogram}}.
}
\description{
Computes the requested degree measure for each node in the graph.
}
\examples{

# Comparing degree measurements ---------------------------------------------
# Creating an undirected graph
graph <- rgraph_ba()
graph

data.frame(
   In=dgr(graph, "indegree", undirected = FALSE),
   Out=dgr(graph, "outdegree", undirected = FALSE),
   Degree=dgr(graph, "degree", undirected = FALSE)
 )

# Testing on Korean Family Planning (weighted graph) ------------------------
data(kfamilyDiffNet)
d_unvalued <- dgr(kfamilyDiffNet, valued=FALSE)
d_valued   <- dgr(kfamilyDiffNet, valued=TRUE)

any(d_valued!=d_unvalued)

# Classic Scale-free plot ---------------------------------------------------
set.seed(1122)
g <- rgraph_ba(t=1e3-1)
hist(dgr(g))

# Since by default uses logscale, here we suppress the warnings
# on points been discarded for <=0.
suppressWarnings(plot(dgr(g)))

}
\author{
George G. Vega Yon
}
\seealso{
Other statistics: \code{\link{classify_adopters}},
  \code{\link{cumulative_adopt_count}},
  \code{\link{ego_variance}}, \code{\link{exposure}},
  \code{\link{hazard_rate}}, \code{\link{infection}},
  \code{\link{moran}}, \code{\link{struct_equiv}},
  \code{\link{threshold}},
  \code{\link{vertex_covariate_dist}}

Other visualizations: \code{\link{diffusionMap}},
  \code{\link{drawColorKey}},
  \code{\link{grid_distribution}},
  \code{\link{hazard_rate}}, \code{\link{plot_adopters}},
  \code{\link{plot_diffnet2}}, \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\keyword{univar}

