% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graph.R
\name{rgraph_ba}
\alias{rgraph_ba}
\alias{scale-free}
\title{Barabasi-Albert model}
\usage{
rgraph_ba(m0 = 1L, m = 1L, t = 10L, graph = NULL)
}
\arguments{
\item{m0}{Integer scalar. Number of initial vertices in the graph.}

\item{m}{Integer scalar. Number of new edges per vertex added.}

\item{t}{Integer scalar. Number of time periods (steps).}

\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}
}
\value{
If \code{graph} is not provided, a static graph, otherwise an expanded
graph (\code{t} aditional vertices) of the same class as \code{graph}.

The resulting graph will have \code{graph$meta$undirected = FALSE} if it is of
class \code{diffnet} and \code{attr(graph, "undirected")=FALSE} otherwise.
}
\description{
Generates a scale-free random graph.
}
\details{
Creates an undirected random graph of size \code{t + m0}.
}
\examples{
# Using another graph as a base graph
graph <- rgraph_ba()
graph

graph <- rgraph_ba(graph=graph)
}
\author{
Vega Yon
}
\references{
Albert-László Barabási, & Albert, R. (1999). Emergence of Scaling in Random
Networks. Science, 286(5439), 509–512. \url{http://doi.org/10.1126/science.286.5439.509}

Albert-László Barabási. (2016). Network Science: (1st ed.). Cambridge University Press.
Retrieved from \url{http://barabasi.com/book/network-science}
}
\seealso{
Other simulation functions: \code{\link{rdiffnet}},
  \code{\link{rewire_graph}}, \code{\link{rgraph_er}},
  \code{\link{rgraph_ws}}
}
\concept{
Scale-free random graph

Barabasi-Albert model

Random graph
}
\keyword{distribution}

