% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{DataSetUpdate}
\alias{DataSetUpdate}
\title{Update local data sets and update R/sysdata.rda file}
\usage{
DataSetUpdate(ds = "all", samples = FALSE, use.remote = TRUE)
}
\arguments{
\item{ds}{Selects the data set for this operation. Default set to "all".
Check available options with DataSetList()}

\item{samples}{if TRUE it will create sample data.frames and store them in /data}

\item{use.remote}{if TRUE it will download sysdata.rda from net.security github}
}
\value{
Date Official source files download date time.
}
\description{
\code{DataSetUpdate} Starts the process for updating local data sets available with \code{\link{GetDataFrame}} function.
}
\details{
The process include the following phases:
\enumerate{
   \item Download files from MITRE, NIST and INCIBE sources.
   \item Process MITRE raw data.
   \item Process NIST raw data. One file per year.
   \item Indexing data. Includes CSV and XML parsing. Build data frame.
   \item Tidy data frame.
   \item Compress and save data.frame to internal data.
}
}
\examples{
\dontrun{
net.security::DataSetUpdate(ds = "all")
}
\dontrun{
net.security::DataSetUpdate(ds = "cves")
}
}
