% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cypher.R
\name{cypher}
\alias{cypher}
\title{Run a cypher query}
\usage{
cypher(
  graph,
  query,
  parameters = NULL,
  result = c("row", "graph"),
  arraysAsStrings = TRUE,
  eltSep = " || "
)
}
\arguments{
\item{graph}{the neo4j connection}

\item{query}{the cypher query}

\item{parameters}{parameters for the cypher query.}

\item{result}{the way to return results. "row" will return a data frame
and "graph" will return a list of nodes, a list of relationships
and a list of paths (vectors of relationships identifiers).}

\item{arraysAsStrings}{if result="row" and arraysAsStrings is TRUE (default)
array from neo4j are converted to strings and array elements are
separated by eltSep.}

\item{eltSep}{if result="row" and arraysAsStrings is TRUE (default)
array from neo4j are converted to strings and array elementes are
separated by eltSep.}
}
\value{
the "result" of the query (invisible). See the "result" param.
}
\description{
Run a cypher query
}
\examples{
\dontrun{
# 2 identical queries
result <- cypher(
   graph=graph,
   query='match (n {value:$value}) return n',
   parameters=list(value="100"),
   result="graph"
)
result <- cypher(
   graph=graph,
   query='match (n {value:"100"}) return n',
   result="graph"
)
}

}
\seealso{
\code{\link[=startGraph]{startGraph()}}, \code{\link[=prepCql]{prepCql()}}, \code{\link[=readCql]{readCql()}} and \code{\link[=graphRequest]{graphRequest()}}
}
