\name{optimset}
\alias{optimset}
\title{
  Configures and returns an optimization data structure.
}
\description{
  This function creates or updates a list which can be used to modify
  the behaviour of optimization methods. The goal of this function is to manage
  the \code{options} list with a set of fields (for example, 'MaxFunEvals',
  'MaxIter', etc...). The user can create a new list with empty fields or
  create a new structure with default fields which correspond to a particular
  algorithm. The user can also configure each field and set it to a particular
  value. Finally, the user passes the list to an optimization function so
  that the algorithm uses the options configured by the user.
}
\usage{
  optimset(method = NULL,
           Display = NULL,
           FunValCheck = NULL,
           MaxFunEvals = NULL,
           MaxIter = NULL,
           OutputFcn = NULL,
           PlotFcns = NULL,
           TolFun = NULL,
           TolX = NULL)
}
\arguments{
  \item{method}{If provided, the \code{method} argument overrides all the
   others and \code{optimset.method} is called. If the content of \code{method}
   is recognized, a defuault set of options are returned. The only current
   recognized character string is 'fminsearch'.}
  \item{Display}{The verbose level. The default value is 'notify'. The following
    is a list of available verbose levels.\describe{
      \item{'off'}{The algorithm displays no message at all.}
      \item{'notify'}{The algorithm displays message if the termination criteria
        is not reached at the end of the optimization. This may happen if the
        maximum number or iterations of the maximum number of function
        evaluations is reached and warns the user of a convergence problem.}
      \item{'final'}{The algorithm displays a message at the end of the
        optimization, showing the number of iterations, the number of function
        evaluations and the status of the optimization. This option includes the
        messages generated by the 'notify' option i.e. warns in case of a
        convergence problem.}
      \item{'iter'}{The algorithm displays a one-line message at each iteration.
        This option includes the messages generated by the 'notify' option i.e.
        warns in case of a convergence problem. It also includes the message
        generated by the 'final' option.}
    }
  }
  \item{FunValCheck}{A logical flag to enable the checking of function values.}
  \item{MaxFunEvals}{The maximum number of evaluations of the cost function.}
  \item{MaxIter}{The maximum number of iterations.}
  \item{OutputFcn}{A function which is called at each iteration to print out
    intermediate state of the optimization algorithm (for example into a log
    file).}
  \item{PlotFcns}{A function which is called at each iteration to plot the
    intermediate state of the optimization algorithm (for example into a 2D
    graphic).}
  \item{TolFun}{The absolute tolerance on function value.}
  \item{TolX}{The absolute tolerance on the variable x.}
}
\details{
  Most optimization algorithms require many algorithmic parameters such as the
  number of iterations or the number of function evaluations. If these
  parameters are given to the optimization function as input parameters, this
  forces both the user and the developper to manage many input parameters. The
  goal of the \code{optimset} function is to simplify the management of input
  arguments, by gathering all the parameters into a single list.

  While the current implementation of the \code{optimset} function only supports
  the \code{fminsearch} function, it is designed to be extended to as many
  optimization function as required. Because all optimization algorithms do not
  require the same parameters, the data structure aims at remaining flexible.
  But, most of the time, most parameters are the same from algorithm to
  algorithm, for example, the tolerance parameters which drive the termination
  criteria are often the same, even if the termination criteria itself is not
  the same.

  \strong{Output and plot functions}
  The 'OutputFcn' and 'PlotFcns' options accept as argument a function (or a
  list of functions). In the client optimization algorithm, this output or plot
  function is called back once per iteration. It can be used by the user to
  display a message in the console, write into a file, etc...
  The output or plot function is expected to have the following definition:

  myfun <- function(x, optimValues, state)

  where the input parameters are:\describe{
    \item{x}{The current point estimate.}
    \item{optimValues}{A list which contains the following fields:\describe{
      \item{funccount}{The number of function evaluations.}
      \item{fval}{The best function value.}
      \item{iteration}{The current iteration number.}
      \item{procedure}{The type of step performed. This string depends on the
        specific algorithm (see \code{fminsearch} for details).}
      }
    }
    \item{state}{the state of the algorithm. The following states are
      available:\describe{
      \item{'init'}{when the algorithm is initializing,}
      \item{'iter'}{when the algorithm is performing iterations,}
      \item{'done'}{when the algorithm is terminated.}
      }
    }
  }
}
\value{
  Return a list with the following fields: Display, FunValCheck, MaxFunEvals,
  MaxIter, OutputFcn, PlotFcns, TolFun, and TolX.
}
\author{
Author of Scilab neldermead module: Michael Baudin (INRIA - Digiteo)

Author of R adaptation: Sebastien Bihorel (\email{sb.pmlab@gmail.com})
}
\seealso{
  \code{\link{optimset.method}},\code{\link{fminsearch}}
}
\examples{
  optimset()
  optimset(Display='iter')
}
\keyword{ method }
