% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{npercent}
\alias{npercent}
\title{neat representation of percentage}
\usage{
npercent(
  percent,
  is.decimal = TRUE,
  digits = 1,
  plus.sign = TRUE,
  factor.out = FALSE
)
}
\arguments{
\item{percent}{an integer or double representing percentage}

\item{is.decimal}{a Boolean variable. If the percent is raw, the value to set as TRUE. See examples below.
If the percent variable is already pre-multiplied by 100 then the value to be set as FALSE.}

\item{digits}{number of digits to round-off}

\item{plus.sign}{a Boolean variable. If the percent is positive then setting plus_sign = TRUE, includes an explicit + sign before the percent}

\item{factor.out}{an optional Boolean variable. If the percent exceeds |100%| then a string representing growth or drop as
readable factors. See examples below.}
}
\value{
String representation of the percentages.
}
\description{
neat representation of percentage
}
\examples{
# Formatting 22.3\%
npercent(0.223, is.decimal = TRUE, digits = 1)
npercent(22.3, is.decimal = FALSE, digits = 1)
# Formatting percentages with growth factors
npercent(c(-4.01, 2.56), is.decimal = TRUE, factor.out = TRUE)
}
