% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCFObjects.R
\name{makeAxis}
\alias{makeAxis}
\title{Create an axis}
\usage{
makeAxis(name, group, orientation, values, bounds = NULL)
}
\arguments{
\item{name}{Name of the axis.}

\item{group}{Group to place the axis in.}

\item{orientation}{The orientation of the axis. Must be one of "X", "Y", "Z",
or "T" for longitude, latitude, height or depth, and time axes,
respectively. For any other axis, indicate an empty string ""}

\item{values}{The coordinate values. In the case of an axis with
\code{orientation = "T"} this must be a \code{CFTime} instance.}

\item{bounds}{The bounds of the coordinate values, or \code{NULL} if not
available.}
}
\value{
An instance of a class descending from \link{CFAxis}.
}
\description{
With this method you can create an axis to use with new \link{CFArray} instances.
Depending on the \code{orientation} argument and the type of the \code{values} argument
an instance of a class descending from \link{CFAxis} will be returned.
}
\details{
There are several restrictions on the combination of \code{orientation} and
\code{values} arguments. Longitude and latitude axes (\code{orientation} of "X" or "Y")
must have numeric \code{values}. For a time axis (\code{orientation} of "T") the
\code{values} argument must be an instance of \code{CFTime} or \code{CFClimatology}.
}
\seealso{
\code{\link[=makeLongitudeAxis]{makeLongitudeAxis()}}, \code{\link[=makeLatitudeAxis]{makeLatitudeAxis()}}, \code{\link[=makeTimeAxis]{makeTimeAxis()}}, \code{\link[=makeDiscreteAxis]{makeDiscreteAxis()}}
}
