% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFDataset.R
\docType{methods}
\name{[[.CFDataset}
\alias{[[.CFDataset}
\alias{[[,CFDataset-method}
\title{Get a variable or axis object from a data set}
\usage{
\method{[[}{CFDataset}(x, i)
}
\arguments{
\item{x}{An \code{CFDataset} to extract a variable or axis from.}

\item{i}{The name of a variable or axis in \code{x}. If data set \code{x} has groups,
\code{i} should be an absolute path to the object to retrieve.}
}
\value{
An instance of \code{CFVariable} or an \code{CFAxis} descendant class, or
\code{NULL} if the name is not found.
}
\description{
This method can be used to retrieve a variable or axis from the data set by
name.
}
\details{
If the data set has groups, the name \code{i} of the variable or axis should be
fully qualified with the path to the group where the object is located. This
fully qualified name can be retrieved with the \code{\link[=names]{names()}} and \code{\link[=dimnames]{dimnames()}}
functions, respectively.
}
\examples{
fn <- system.file("extdata", "ERA5land_Rwanda_20160101.nc", package = "ncdfCF")
ds <- open_ncdf(fn)
v1 <- names(ds)[1]
var <- ds[[v1]]
var
}
