% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfDimension.R, R/ncdfDimensionCharacter.R,
%   R/ncdfDimensionNumeric.R, R/ncdfDimensionTime.R
\name{indexOf}
\alias{indexOf}
\alias{indexOf,character,ncdfDimensionCharacter-method}
\alias{indexOf,numeric,ncdfDimensionNumeric-method}
\alias{indexOf,ANY,ncdfDimensionTime-method}
\title{Find indices in the dimension domain}
\usage{
\S4method{indexOf}{character,ncdfDimensionCharacter}(x, y, method = "constant")

\S4method{indexOf}{numeric,ncdfDimensionNumeric}(x, y, method = "constant")

\S4method{indexOf}{ANY,ncdfDimensionTime}(x, y, method = "constant")
}
\arguments{
\item{x}{Vector of numeric, timestamp or categorial values to find dimension
indices for. The timestamps can be either character, POSIXct or Date vectors.
The type of the vector has to correspond to the type of \code{y}.}

\item{y}{An instance of \code{ncdfDimensionNumeric}, \code{ncdfDimensionTime} or
\code{ncdfDimensionCharacter}.}

\item{method}{Single value of "constant" or "linear".}
}
\value{
Numeric vector of the same length as \code{x}. If \code{method = "constant"},
return the index value for each match. If \code{method = "linear"}, return the
index value with any fractional value. Values of \code{x} outside of the range
of the values in \code{y} are returned as \code{0} and \code{.Machine$integer.max},
respectively.
}
\description{
Given a vector of numerical, timestamp or categorical values \code{x}, find their
indices in the values of dimension \code{y}. With \code{method = "constant"} this
returns the index of the value lower than the supplied values in \code{x}. With
\code{method = "linear"} the return value includes any fractional part.

If bounds are set on the numerical or time dimension, the indices are taken
from those bounds. Returned indices may fall in between bounds if the latter
are not contiguous, with the exception of the extreme values in \code{x}.
}
\examples{
fn <- system.file("extdata",
                  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
                  package = "ncdfCF")
ds <- open_ncdf(fn)
lon <- ds[["lon"]]
indexOf(c(8.5, 8.9, 9.3, 9.7, 10.1), lon)
indexOf(c(8.5, 8.9, 9.3, 9.7, 10.1), lon, "linear")

time <- ds[["time"]]
indexOf(c("2024-03-01", "2024-03-02"), time)
}
