% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{nc.get.dim.for.axis}
\alias{nc.get.dim.for.axis}
\title{Get dimension corresponding to a given axis}
\usage{
nc.get.dim.for.axis(f, v, axis)
}
\arguments{
\item{f}{The file (an object of class \code{ncdf4})}

\item{v}{The source variable: a string naming a variable in a file or an object of class \code{ncvar4}.}

\item{axis}{The axis to retrieve the dimension for: a string consisting of either X, Y, Z, T, or S.}
}
\value{
An object of class \code{ncdim4} if a dimension is found for the specified axis; \code{NA} otherwise.
}
\description{
Get dimension corresponding to a given axis.
}
\details{
This function returns the dimension (of class 'ncdim4') corresponding to the specified axis (X, Y, Z, T, or S).
}
\examples{
## Get dimension for X axis
\dontrun{
f <- nc_open("pr.nc")
x.axis.dim <- nc.get.dim.axes.from.names(f, "pr", "X")
nc_close(f)
}

}
