\name{nc.conform.data}
\alias{nc.conform.data}
\title{Conform data to dimension order and structure of output}
\usage{
nc.conform.data(f.input, f.output, v.input, v.output, dat.input,
  allow.dim.subsets = FALSE)
}
\arguments{
  \item{f.input}{The input file (an object of class
  \code{ncdf4})}

  \item{f.output}{The output file (an object of class
  \code{ncdf4})}

  \item{v.input}{The input variable (a string naming a
  variable in a file or an object of class \code{ncvar4}).}

  \item{v.output}{The output variable (a string naming a
  variable in a file or an object of class \code{ncvar4}).}

  \item{dat.input}{The input data to be reordered to match
  the output file's ordering.}

  \item{allow.dim.subsets}{Whether to allow the conforming
  process to subset the data.}
}
\value{
The data permuted to match the output file's ordering and
optionally clipped to the extent of the output.
}
\description{
Conform data to dimension order and structure of output.
}
\details{
Sometimes files come in in different latitude (up is north,
up is south), longitude (0 to 360 vs -180 to 180), and
temporal schemes. The purpose of this function is to make
data from one scheme comparable to data from another. It
takes a given input file, variable, and slab of data and
permutes the data such that the dimension order and the
index order matches the order in the output file and
variable.
}
\note{
This function currently isn't useful for conforming subsets
of output data.
}
\examples{
## Get data from one file and conform it to the dimension order of another.
\dontrun{
f1 <- nc_open("pr.nc")
f2 <- nc_open("pr2.nc", write=TRUE)
dat <- nc.get.var.subset.by.axes(f1, "pr")
new.dat <- nc.conform.data(f2, f1, "pr", "pr", dat)
nc_close(f1)
nc_close(f2)
}
}

