% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calc_dists_dotprods}
\alias{calc_dists_dotprods}
\title{Calculate distances and dot products between two sets of neurons}
\usage{
calc_dists_dotprods(query_neurons, target_neurons, subset = NULL,
  ignoreSelf = TRUE, ...)
}
\arguments{
\item{query_neurons}{a \code{\link[nat]{neuronlist}} to use for calculating
distances and dot products.}

\item{target_neurons}{a further \code{\link[nat]{neuronlist}} to use for
calculating distances and dot products.}

\item{subset}{a \code{\link{data.frame}} specifying which neurons in
\code{query_neurons} and \code{target_neurons} should be compared, with
columns specifying query and target neurons by name, with one row for each
pair. If unspecified, this defaults to an all-by-all comparison.}

\item{ignoreSelf}{a Boolean indicating whether to ignore comparisons of a
neuron against itself (default \code{TRUE}).}

\item{...}{extra arguments to pass to \code{\link{NeuriteBlast}}.}
}
\value{
A list, one element for for pair of neurons with a 2 column
  data.frame containing one column of distances and s secon of absolute dot
  products.
}
\description{
Calculate distances and dot products between two sets of neurons
}
\details{
Distances and dot products are the raw inputs for constructing
  scoring matrices for the nblast search algorithm.
}

