% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{\%~>\%}
\alias{\%~>\%}
\title{Signal Forwarder}
\usage{
cv \%~>\% cv2
}
\arguments{
\item{cv}{a 'conditionVariable' object, from which to forward the signal.}

\item{cv2}{a 'conditionVariable' object, to which the signal is forwarded.}
}
\value{
Invisibly, \code{cv2}.
}
\description{
Forwards signals from one 'conditionVariable' to another.
}
\details{
The condition value of \code{cv} is initially reset to zero when this operator
returns. Only one forwarder can be active on a \code{cv} at any given time, and
assigning a new forwarding target cancels any currently existing forwarding.

Changes in the condition value of \code{cv} are forwarded to \code{cv2}, but only on
each occassion \code{cv} is signalled. This means that waiting on \code{cv} will cause
a temporary divergence between the actual condition value of \code{cv} and that
recorded at \code{cv2}, until the next time \code{cv} is signalled.
}
\examples{
cva <- cv(); cvb <- cv(); cv1 <- cv(); cv2 <- cv()

cva \%~>\% cv1 \%~>\% cv2
cvb \%~>\% cv2

cv_signal(cva)
cv_signal(cvb)
cv_value(cv1)
cv_value(cv2)

}
