% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{send_aio}
\alias{send_aio}
\title{Send Async}
\usage{
send_aio(con, data, mode = c("serial", "raw"), timeout = NULL, pipe = 0L)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if \code{mode = "raw"}).}

\item{mode}{[default 'serial'] character value or integer equivalent -
either \code{"serial"} (1L) to send serialised R objects, or \code{"raw"} (2L) to
send atomic vectors of any type as a raw byte vector. For Streams, \code{"raw"}
is the only option and this argument is ignored.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout.}

\item{pipe}{[default 0L] only applicable to Sockets using the 'poly'
protocol, an integer pipe ID if directing the send via a specific pipe.}
}
\value{
A 'sendAio' (object of class 'sendAio') (invisibly).
}
\description{
Send data asynchronously over a connection (Socket, Context, Stream or Pipe).
}
\details{
Async send is always non-blocking and returns a 'sendAio' immediately.

For a 'sendAio', the send result is available at \verb{$result}. An 'unresolved'
logical NA is returned if the async operation is yet to complete. The
resolved value will be zero on success, or else an integer error code.

To wait for and check the result of the send operation, use \code{\link[=call_aio]{call_aio()}} on
the returned 'sendAio' object.

Alternatively, to stop the async operation, use \code{\link[=stop_aio]{stop_aio()}}.
}
\section{Send Modes}{


The default mode \code{"serial"} sends serialised R objects to ensure perfect
reproducibility within R. When receiving, the corresponding mode \code{"serial"}
should be used. Custom serialization and unserialization functions for
reference objects may be enabled by the function \code{\link[=serial_config]{serial_config()}}.

Mode \code{"raw"} sends atomic vectors of any type as a raw byte vector, and must
be used when interfacing with external applications or raw system sockets,
where R serialization is not in use. When receiving, the mode corresponding
to the vector sent should be used.
}

\examples{
pub <- socket("pub", dial = "inproc://nanonext")

res <- send_aio(pub, data.frame(a = 1, b = 2), timeout = 100)
res
res$result

res <- send_aio(pub, "example message", mode = "raw", timeout = 100)
call_aio(res)$result

close(pub)

}
\seealso{
\code{\link[=send]{send()}} for synchronous send.
}
