% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{send_vec_aio}
\alias{send_vec_aio}
\title{Send Vector Async}
\usage{
send_vec_aio(socket, ..., timeout)
}
\arguments{
\item{socket}{a Socket.}

\item{...}{one or more R objects to send (serialised) asynchronously.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}
}
\value{
A vector of zeros (invisibly) on success.
}
\description{
Send any number of R vectors asynchronously over a Socket, with the ability
    to set (optional) send timeouts. Data will be sent as binary without R
    serialisation, hence appropriate for interfacing with external programs.
}
\details{
Will block if the send is in progress and has not yet completed -
    certain protocol / transport combinations may limit the number of messages
    that can be queued if they have yet to be received. Set a timeout to
    ensure the function returns under all conditions.
}
\examples{
pub <- socket("pub", dial = "inproc://nanonext")

send_vec_aio(pub, "message 1", "message 2", timeout = 100)
out <- send_vec_aio(pub, "message 1", "message 2", timeout = 100)
out

close(pub)

}
