% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{cc-nb-img-classes}
\alias{cc-nb-img-classes}
\alias{cc_number_img}
\alias{cc_brightness_img}
\title{Cross-correlated number and brightness image classes.}
\usage{
cc_number_img(img, thresh, swaps, filt)

cc_brightness_img(img, thresh, swaps, filt)
}
\arguments{
\item{img}{The calculated cross-correlated number or brightness image.}

\item{thresh}{A positive integer, possibly an object of class
\link[autothresholdr:th]{autothresholdr::th}. If the different channels of the image had different
thresholds, this argument may be specified as a vector or list (of positive
integers, possibly objects of class \link[autothresholdr:th]{autothresholdr::th}), one element for
each channel.}

\item{swaps}{A non-negative integer with an attribute \code{auto}. If the
different channels of the image had different \code{swaps}, this argument may be
specified as a list (of non-negative integers with attributes \code{auto}), one
element for each channel. For undetrended images, set \code{swaps = NA}.}

\item{filt}{A string, the filtering method used. Must be either \code{"mean"} or
\code{"median"}, or \code{NA} for no filtering. If the different channels of the
image had different filters, this may be specified as a character vector,
one element for each channel.}
}
\value{
An object of class \code{cc_number_img} or \code{cc_brightness_img}.
}
\description{
The \code{cc_number_img} and \code{cc_brightness_img} classes are designed to hold
objects which are images calculated from the \emph{cross-correlated number and
brightness} technique.
}
\details{
An object of class \code{cc_number_img} or \code{cc_brightness_img} is a 4-dimensional
array of real numbers in the mould of an \link[ijtiff:ijtiff_img]{ijtiff_img}
(indexed as \code{img[y, x, channel, frame]}) with 3 attributes:
\describe{\item{\code{thresh}}{A positive integer, possibly an object of class
\link[autothresholdr:th]{autothresholdr::th} detailing which threshold and thresholding method was
used in preprocessing (in the multi-channel case, one threshold per channel
is given).} \item{\code{swaps}}{A non-negative integer indicating the number of
swaps used for Robin Hood detrending, with an attribute \code{auto} which is a
logical indicating whether or not the parameter was chosen automatically (in
the multi-channel case, one \code{swaps} per channel is given).}\item{\code{filt}}{Was
mean or median filtering used in postprocessing?}}
}
