% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_var_proportions.R
\name{run_var_proportions}
\alias{run_var_proportions}
\title{Run random effects modeling on \code{mx_dataset} object to determine proportions of variance at the slide level}
\usage{
run_var_proportions(
  mx_data,
  table,
  metadata_cols = NULL,
  formula_override = NULL,
  save_models = FALSE,
  ...
)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute UMAP dimensions}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{metadata_cols}{other identifiers of the input \code{data} to use in the modeling process (default=NULL). This must be a vector of column name(s) in the \code{mx_dataset} object}

\item{formula_override}{String with user-defined formula to use for variance proportions modeling analysis (default=NULL). This will be the RHS of a formula with \verb{marker~} as the LHS.}

\item{save_models}{Boolean flag to save \code{lme4::lmer()} models in a list to the \code{mx_dataset} object}

\item{...}{optional additional arguments for \code{lme4::lmer()} modeling}
}
\value{
\code{mx_dataset} object with modeling results in \code{var_data} table
}
\description{
Run random effects modeling on \code{mx_dataset} object to determine proportions of variance at the slide level
}
\examples{
mx_data = mx_dataset(mxnorm::mx_sample, "slide_id", "image_id",
  c("marker1_vals","marker2_vals","marker3_vals"),
  c("metadata1_vals"))
mx_data = mx_normalize(mx_data, transform="log10",method="None")
mx_data = run_var_proportions(mx_data, table="both")
}
