/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;

public class Signals {
    private List<Set<Unit>> sets = new ArrayList<Set<Unit>>();
    private Map<Unit, List<Integer>> unitsSets = new HashMap<Unit, List<Integer>>();
    private List<OptionalDouble> weights = new ArrayList<OptionalDouble>();

    public Signals() {
    }

    public Signals negativeSignals() {
        Signals s = new Signals();
        s.sets = new ArrayList<Set<Unit>>(this.sets);
        s.weights = new ArrayList<OptionalDouble>(this.weights);
        for (Map.Entry<Unit, List<Integer>> kvp : this.unitsSets.entrySet()) {
            Unit unit = kvp.getKey();
            List unitSet = kvp.getValue().stream().filter(v -> this.weight((int)v) < 0.0).collect(Collectors.toList());
            s.unitsSets.put(unit, unitSet);
        }
        return s;
    }

    public Signals(Signals signals, Set<Unit> subset) {
        this();
        for (Unit unit : subset) {
            this.unitsSets.put(unit, new ArrayList());
        }
        int j = 0;
        for (int i = 0; i < signals.size(); ++i) {
            HashSet<Unit> set = new HashSet<Unit>();
            for (Unit unit : signals.set(i)) {
                if (!subset.contains(unit)) continue;
                set.add(unit);
                this.unitsSets.get(unit).add(j);
            }
            if (set.isEmpty()) continue;
            this.sets.add(set);
            this.weights.add(OptionalDouble.of(signals.weight(i)));
            ++j;
        }
    }

    public int size() {
        return this.sets.size();
    }

    public double weight(int num) {
        assert (this.weights.get(num).isPresent());
        return this.weights.get(num).getAsDouble();
    }

    public Stream<Integer> filter(Set<Integer> sets, Predicate<Integer> pred) {
        return sets.stream().filter(pred);
    }

    public double minSum(Collection<? extends Unit> units) {
        return this.minSum(units.toArray(new Unit[0]));
    }

    public double maxSum(Collection<? extends Unit> units) {
        return this.maxSum(units.toArray(new Unit[0]));
    }

    public double maxSum(Unit ... units) {
        return this.sum(units);
    }

    public double minSum(Unit ... units) {
        return this.sumByPredicate(units, s -> this.set((int)s).size() == 1 || this.weight((int)s) < 0.0);
    }

    private double sumByPredicate(Unit[] units, Predicate<Integer> pred) {
        return this.unitSets(Arrays.stream(units), true).filter(pred).mapToDouble(this::weight).sum();
    }

    public double weight(Unit unit) {
        return this.unitsSets.get(unit).stream().mapToDouble(this::weight).sum();
    }

    public void join(Unit what, Unit with) {
        List<Integer> x = this.unitsSets.get(what);
        List<Integer> main = this.unitsSets.get(with);
        int i = 0;
        int j = 0;
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (i != x.size() || j != main.size()) {
            int set;
            if (j != main.size() && (i == x.size() || main.get(j) < x.get(i))) {
                set = main.get(j);
                ++j;
            } else {
                set = x.get(i);
                this.sets.get(set).remove(what);
                this.sets.get(set).add(with);
                ++i;
            }
            if (!result.isEmpty() && (Integer)result.get(result.size() - 1) == set) continue;
            result.add(set);
        }
        this.unitsSets.put(with, result);
        result = new ArrayList(new HashSet(this.unitsSets.get(with)));
        this.unitsSets.put(with, result);
        this.unitsSets.remove(what);
    }

    public Map<Unit, List<Integer>> unitSets() {
        HashMap<Unit, List<Integer>> result = new HashMap<Unit, List<Integer>>();
        for (Unit unit : this.unitsSets.keySet()) {
            result.put(unit, this.unitsSets.get(unit));
        }
        return result;
    }

    public double sum(Unit ... units) {
        return this.weightSum(this.unitSets(units));
    }

    public double sum(Collection<? extends Unit> units) {
        return this.weightSum(this.unitSets(units));
    }

    public double weightSum(Stream<Integer> sets) {
        return sets.distinct().mapToDouble(this::weight).sum();
    }

    public double weightSum(Collection<Integer> sets) {
        return this.weightSum(sets.stream());
    }

    public boolean bijection(Unit unit) {
        List<Integer> ss = this.unitSets(unit);
        return ss.stream().allMatch(s -> this.set((int)s).size() == 1);
    }

    public Set<Integer> positiveUnitSets(Unit ... units) {
        return this.positiveUnitSets(Arrays.asList(units));
    }

    public Set<Integer> positiveUnitSets(Collection<? extends Unit> units) {
        return this.unitSets(units.stream(), true).filter(u -> this.weight((int)u) > 0.0).collect(Collectors.toSet());
    }

    public Set<Integer> positiveUnitSets(Unit unit) {
        return this.positiveUnitSets(Collections.singletonList(unit));
    }

    public List<Integer> positiveUnitSets(Collection<? extends Unit> units, boolean distinct2) {
        return this.unitSets(units.stream(), distinct2).filter(s -> this.weight((int)s) > 0.0).collect(Collectors.toList());
    }

    public Set<Integer> negativeUnitSets(Unit ... units) {
        return this.negativeUnitSets(Arrays.asList(units));
    }

    public Set<Integer> negativeUnitSets(Collection<? extends Unit> units) {
        return this.unitSets(units.stream(), true).filter(u -> this.weight((int)u) < 0.0).collect(Collectors.toSet());
    }

    public Set<Integer> negativeUnitSets(Unit unit) {
        return this.negativeUnitSets(Collections.singletonList(unit));
    }

    public List<Integer> negativeUnitSets(Collection<? extends Unit> units, boolean distinct2) {
        return this.unitSets(units.stream(), distinct2).filter(u -> this.weight((int)u) < 0.0).collect(Collectors.toList());
    }

    public Set<Integer> unitSets(Unit ... units) {
        return this.unitSets(Arrays.stream(units), true).collect(Collectors.toSet());
    }

    public Set<Integer> unitSets(Collection<? extends Unit> units) {
        return this.unitSets(units.toArray(new Unit[0]));
    }

    public List<Integer> unitSets(Unit unit) {
        return Collections.unmodifiableList(this.unitsSets.get(unit));
    }

    public List<Integer> unitSets(Collection<? extends Unit> units, boolean distinct2) {
        return this.unitSets(units.stream(), distinct2).collect(Collectors.toList());
    }

    public Stream<Integer> unitSets(Stream<? extends Unit> units, boolean distinct2) {
        Stream<Integer> res = units.map(this::unitSets).flatMap(Collection::stream);
        return distinct2 ? res.distinct() : res;
    }

    public List<Unit> set(int num) {
        ArrayList<Unit> result = new ArrayList<Unit>((Collection)this.sets.get(num));
        return result;
    }

    public void add(Unit unit, int signalTo) {
        this.sets.get(signalTo).add(unit);
        this.ensureLink(unit, signalTo);
    }

    private int add(Unit unit) {
        HashSet<Unit> s = new HashSet<Unit>();
        s.add(unit);
        this.sets.add(s);
        this.weights.add(OptionalDouble.empty());
        int num = this.sets.size() - 1;
        this.ensureLink(unit, num);
        return num;
    }

    public void remove(Unit unit, int from) {
        this.sets.get(from).remove(unit);
        this.unitsSets.get(unit).remove(from);
    }

    public boolean canReplace(Set<Unit> w, Set<Unit> who, Set<Unit> whom) {
        double wsum = this.maxSum(w);
        w.retainAll(whom);
        w.addAll(who);
        double replSum = this.maxSum(w);
        return replSum >= wsum;
    }

    public void remove(Unit unit) {
        List<Integer> us = this.unitsSets.get(unit);
        for (int s : us) {
            this.sets.get(s).remove(unit);
        }
        this.unitsSets.remove(unit);
    }

    public int addAndSetWeight(Unit unit, Double weight2) {
        int num = this.add(unit);
        this.setWeight(num, weight2);
        return num;
    }

    public void addEdgePenalties(double penalty) throws SolverException {
        if (penalty > 0.0) {
            throw new SolverException("expected negative penalty");
        }
        for (Unit unit : this.unitSets().keySet()) {
            if (!(unit instanceof Edge)) continue;
            if (this.bijection(unit)) {
                int signal = this.unitSets(unit).get(0);
                this.setWeight(signal, this.weight(signal) + penalty);
                continue;
            }
            this.appendSignalToUnit(unit, penalty);
        }
    }

    private void appendSignalToUnit(Unit unit, double weight2) {
        int sig = this.addSignal(weight2);
        this.add(unit, sig);
    }

    public int addSignal(double weight2) {
        this.sets.add(new HashSet());
        this.weights.add(OptionalDouble.of(weight2));
        return this.weights.size() - 1;
    }

    public void setWeight(int set, double weight2) {
        this.weights.set(set, OptionalDouble.of(weight2));
    }

    private void ensureLink(Unit unit, int signal) {
        if (this.unitsSets.containsKey(unit)) {
            this.unitsSets.get(unit).add(signal);
        } else {
            ArrayList<Integer> l = new ArrayList<Integer>();
            this.unitsSets.put(unit, l);
            l.add(signal);
        }
    }
}

