% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFunctions.R
\name{multiNoise}
\alias{multiNoise}
\title{Generate multichannel noise}
\usage{
multiNoise(n, sigma = 1, alpha = length(sigma), ...)
}
\arguments{
\item{n}{An integer specifying the number of observations per channel.}

\item{sigma}{A vector giving the noise levels (standard deviation) for each channel in the multichannel model (see details).}

\item{alpha}{A vector specifying the dependence level in each channel.}

\item{...}{Additional arguments to pass to the \code{fracdiff} package to tightly control the long memory noise.}
}
\description{
Generate a matrix of multichannel (possibly long memory) noise variables
}
\details{
Generates a n by m matrix of noise variables. Long memory variables can be generated by the use of the optional \code{fracdiff} package (if installed). The dependence is specified using the \code{alpha} parameter where \code{alpha} = 2 - 2H where H = Hurst parameter. Long memory is ensured when alpha is between 0 and 1 (H between 1/2 and 1). If \code{alpha} is a single element and \code{sigma} has more than one element (multichannel), then the same dependence level of \code{alpha} is used amongst all of the channels. Otherwise the size of \code{alpha} and \code{sigma} should be the same size.
}
\examples{
n <- 1024
m <- 3
signal <- makeLIDAR(n)
blur <- gammaBlur(n, c(0.5, 0.75, 1), rep(1, m))
X <- blurSignal(signal, blur)
SNR <- 10*1:3
sigma <- sigmaSNR(X, SNR)
E <- multiNoise(n, sigma, alpha = c(0.5, 0.75, 1))
matplot(X + E, type = 'l')
}
\seealso{
\code{\link{sigmaSNR}}
}

